DROP TABLE IF EXISTS asignaciones;

CREATE TABLE `asignaciones` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cliente_id` int NOT NULL,
  `producto_id` int NOT NULL,
  `cantidad` int NOT NULL,
  `fecha_asignacion` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cliente_id` (`cliente_id`),
  KEY `producto_id` (`producto_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO asignaciones VALUES("3","4","9","10","2024-06-03 12:56:56");
INSERT INTO asignaciones VALUES("5","4","9","10","2024-06-03 12:57:04");
INSERT INTO asignaciones VALUES("6","1","0","0","2024-07-31 13:16:49");



DROP TABLE IF EXISTS cliente;

CREATE TABLE `cliente` (
  `idcliente` int NOT NULL AUTO_INCREMENT,
  `cedula` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `apellido` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `sexo` varchar(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `fecha_nacimiento` date NOT NULL,
  `correo` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci DEFAULT NULL,
  `direccion` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `telefono` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci DEFAULT NULL,
  `usuario_id` int NOT NULL,
  `estado` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`idcliente`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_spanish_ci ROW_FORMAT=DYNAMIC;

INSERT INTO cliente VALUES("4","0","Luisana","","","0000-00-00","","petare","04121141255","1","1");
INSERT INTO cliente VALUES("5","30418662","Guillermo Alejandro","Ortiz Molina","M","2004-08-08","guillermortiz96@gmail.com","Ciudadela Zona 7 bloque E apt 2-6","07700150254","1","1");
INSERT INTO cliente VALUES("6","333","MetaFliz","Stream","M","2000-08-08","imguilleo@gmail.com","rrfdssssssssssssssssssssssssss","7279229341","1","1");



DROP TABLE IF EXISTS colecciones;

CREATE TABLE `colecciones` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `stock` int NOT NULL,
  `usuario_id` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO colecciones VALUES("1","Acero de Caballero Manoa Men","50.20","522","1");



DROP TABLE IF EXISTS configuracion;

CREATE TABLE `configuracion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `telefono` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `direccion` text CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_spanish_ci ROW_FORMAT=DYNAMIC;

INSERT INTO configuracion VALUES("1","Siempre Bella\'S","584127780807","notify@metaflixstore.com","USA");



DROP TABLE IF EXISTS configuracion_quincenas;

CREATE TABLE `configuracion_quincenas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tipo_coleccion` varchar(50) NOT NULL,
  `ganancia` decimal(10,2) NOT NULL,
  `fecha_quincena1` date NOT NULL,
  `fecha_quincena2` date NOT NULL,
  `monto_quincena1` decimal(10,2) NOT NULL,
  `monto_quincena2` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO configuracion_quincenas VALUES("1","Basica","54.00","2024-07-31","2024-08-15","80.00","46.00");
INSERT INTO configuracion_quincenas VALUES("2","Especial","44.00","2024-07-31","2024-08-15","86.00","50.00");



DROP TABLE IF EXISTS detalle_permisos;

CREATE TABLE `detalle_permisos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_permiso` int NOT NULL,
  `id_usuario` int NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

INSERT INTO detalle_permisos VALUES("16","1","1");
INSERT INTO detalle_permisos VALUES("17","2","1");
INSERT INTO detalle_permisos VALUES("18","3","1");
INSERT INTO detalle_permisos VALUES("19","4","1");
INSERT INTO detalle_permisos VALUES("20","5","1");
INSERT INTO detalle_permisos VALUES("21","6","1");
INSERT INTO detalle_permisos VALUES("25","3","3");
INSERT INTO detalle_permisos VALUES("54","1","4");
INSERT INTO detalle_permisos VALUES("55","2","4");
INSERT INTO detalle_permisos VALUES("56","3","4");
INSERT INTO detalle_permisos VALUES("57","4","4");
INSERT INTO detalle_permisos VALUES("58","5","4");
INSERT INTO detalle_permisos VALUES("59","6","4");
INSERT INTO detalle_permisos VALUES("60","1","5");
INSERT INTO detalle_permisos VALUES("61","2","5");
INSERT INTO detalle_permisos VALUES("62","3","5");
INSERT INTO detalle_permisos VALUES("63","4","5");
INSERT INTO detalle_permisos VALUES("64","5","5");
INSERT INTO detalle_permisos VALUES("65","6","5");



DROP TABLE IF EXISTS detalle_temp;

CREATE TABLE `detalle_temp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_usuario` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `id_producto` int NOT NULL,
  `cantidad` int NOT NULL,
  `precio_venta` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_spanish_ci ROW_FORMAT=DYNAMIC;




DROP TABLE IF EXISTS detalle_venta;

CREATE TABLE `detalle_venta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_producto` int NOT NULL,
  `id_venta` int NOT NULL,
  `cantidad` int NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;




DROP TABLE IF EXISTS deudas;

CREATE TABLE `deudas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `vendedor_id` int NOT NULL,
  `coleccion_id` int NOT NULL,
  `cantidad` int NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `fecha` date NOT NULL,
  `factura_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `vendedor_id` (`vendedor_id`),
  KEY `coleccion_id` (`coleccion_id`),
  KEY `factura_id` (`factura_id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO deudas VALUES("156","4","9","1","180.00","2024-08-02","135");
INSERT INTO deudas VALUES("157","4","8","1","180.00","2024-08-02","136");
INSERT INTO deudas VALUES("158","2","8","1","180.00","2024-08-02","137");
INSERT INTO deudas VALUES("159","3","8","1","180.00","2024-08-03","138");
INSERT INTO deudas VALUES("160","3","9","1","180.00","2024-08-03","139");
INSERT INTO deudas VALUES("161","3","8","1","180.00","2024-08-03","140");
INSERT INTO deudas VALUES("162","4","8","1","180.00","2024-08-03","141");
INSERT INTO deudas VALUES("163","2","8","1","180.00","2024-08-03","142");
INSERT INTO deudas VALUES("164","2","8","1","180.00","2024-08-04","143");
INSERT INTO deudas VALUES("165","9","8","1","180.00","2024-08-05","144");
INSERT INTO deudas VALUES("166","2","9","1","180.00","2024-08-15","145");
INSERT INTO deudas VALUES("167","2","9","1","180.00","2024-08-15","146");
INSERT INTO deudas VALUES("168","2","9","1","180.00","2024-08-15","147");
INSERT INTO deudas VALUES("169","2","9","1","180.00","2024-08-15","148");
INSERT INTO deudas VALUES("170","2","9","1","180.00","2024-08-15","149");
INSERT INTO deudas VALUES("171","2","8","1","180.00","2024-08-17","150");
INSERT INTO deudas VALUES("172","2","8","1","180.00","2024-08-17","151");



DROP TABLE IF EXISTS deudas_old;

CREATE TABLE `deudas_old` (
  `id` int NOT NULL AUTO_INCREMENT,
  `vendedor_id` int NOT NULL,
  `coleccion_id` int NOT NULL,
  `cantidad` int NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `fecha` date NOT NULL,
  `estado` tinyint(1) DEFAULT '1',
  `factura_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vendedor_id` (`vendedor_id`),
  KEY `coleccion_id` (`coleccion_id`),
  KEY `factura_id` (`factura_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




DROP TABLE IF EXISTS deudas_pagos;

CREATE TABLE `deudas_pagos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cliente_id` int NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `fecha` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` enum('deuda','pago') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cliente_id` (`cliente_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;




DROP TABLE IF EXISTS factura_premios;

CREATE TABLE `factura_premios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `factura_id` int NOT NULL,
  `premio_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `factura_id` (`factura_id`),
  KEY `premio_id` (`premio_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS facturas;

CREATE TABLE `facturas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `vendedor_id` int NOT NULL,
  `fecha` datetime NOT NULL,
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `ganancia` decimal(10,2) DEFAULT NULL,
  `cantidad_colecciones` int DEFAULT NULL,
  `estado` tinyint DEFAULT '1',
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deuda` decimal(10,2) NOT NULL DEFAULT '0.00',
  `premio_id` int DEFAULT NULL,
  `colecciones_basicas` int DEFAULT '0',
  `colecciones_especiales` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vendedor_id` (`vendedor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO facturas VALUES("135","4","2024-08-02 00:00:00","133.00","0.00","0","1","fdjbsfbs","136.00","0","0","1");
INSERT INTO facturas VALUES("136","4","2024-08-03 00:00:00","125.00","0.00","0","1","Renacer C-5 P-1","126.00","0","1","0");
INSERT INTO facturas VALUES("137","2","2024-08-03 00:00:00","125.00","0.00","0","1","Renacer C-5 P-1","126.00","0","1","0");
INSERT INTO facturas VALUES("138","3","2024-08-03 00:00:00","126.00","0.00","0","1","","126.00","0","1","0");
INSERT INTO facturas VALUES("139","3","2024-08-03 00:00:00","136.00","0.00","0","1","","136.00","0","0","1");
INSERT INTO facturas VALUES("140","3","2024-08-03 00:00:00","0.00","0.00","0","1","","126.00","0","1","0");
INSERT INTO facturas VALUES("141","4","2024-08-03 00:00:00","125.00","0.00","0","1","","126.00","0","1","0");
INSERT INTO facturas VALUES("142","2","2024-08-03 00:00:00","126.00","0.00","0","1","","126.00","0","1","0");
INSERT INTO facturas VALUES("143","2","2024-08-03 00:00:00","126.00","","","1","Treinta","126.00","","1","0");
INSERT INTO facturas VALUES("144","9","2024-08-05 00:00:00","101.99","","","1","guillemo","126.00","","1","0");
INSERT INTO facturas VALUES("145","2","2024-08-15 00:00:00","136.00","","","1","","136.00","","0","1");
INSERT INTO facturas VALUES("146","2","2024-08-15 00:00:00","136.00","","","1","","136.00","","0","1");
INSERT INTO facturas VALUES("147","2","2024-08-15 00:00:00","136.00","","","1","","136.00","","0","1");
INSERT INTO facturas VALUES("148","2","2024-08-15 00:00:00","135.00","","","1","","136.00","","0","1");
INSERT INTO facturas VALUES("149","2","2024-08-15 00:00:00","132.00","","","1","","136.00","","0","1");
INSERT INTO facturas VALUES("150","2","2024-08-17 00:00:00","126.00","","","1","Pago","126.00","","1","0");
INSERT INTO facturas VALUES("151","2","2024-08-17 00:00:00","126.00","","","1","Pago","126.00","","1","0");



DROP TABLE IF EXISTS pagos;

CREATE TABLE `pagos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `factura_id` int NOT NULL,
  `banco` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_transaccion` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referencia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_voucher` date NOT NULL,
  `monto_bs` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monto_usd` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `usuario_id` int NOT NULL,
  `tasa` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `factura_id` (`factura_id`),
  KEY `usuario_id` (`usuario_id`)
) ENGINE=MyISAM AUTO_INCREMENT=310 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO pagos VALUES("274","135","Ganancia","Ganancia","Ganancia","2024-08-02","","44","5","");
INSERT INTO pagos VALUES("275","135","Venezuela (Tendencias)","Bolívares","788","2024-08-05","36.65","1.00","5","36.65");
INSERT INTO pagos VALUES("276","135","Divisas","Divisas","-","2024-08-05","-","1","5","-");
INSERT INTO pagos VALUES("277","135","Banesco (Tendencias)","Bolívares","874485","2024-08-05","36.65","1.00","5","36.65");
INSERT INTO pagos VALUES("278","136","Ganancia","Ganancia","Ganancia","2024-08-02","","54","5","");
INSERT INTO pagos VALUES("279","137","Ganancia","Ganancia","Ganancia","2024-08-02","","54","5","");
INSERT INTO pagos VALUES("280","137","Divisas","Divisas","-","2024-08-10","-","1","5","-");
INSERT INTO pagos VALUES("281","138","Ganancia","Ganancia","Ganancia","2024-08-03","","54","5","");
INSERT INTO pagos VALUES("282","139","Ganancia","Ganancia","Ganancia","2024-08-03","","44","5","");
INSERT INTO pagos VALUES("283","140","Ganancia","Ganancia","Ganancia","2024-08-03","","54","5","");
INSERT INTO pagos VALUES("284","141","Ganancia","Ganancia","Ganancia","2024-08-03","","54","5","");
INSERT INTO pagos VALUES("285","142","Ganancia","Ganancia","Ganancia","2024-08-03","","54","5","");
INSERT INTO pagos VALUES("286","143","Ganancia","Ganancia","Ganancia","2024-08-04","","54","1","");
INSERT INTO pagos VALUES("287","136","Venezuela (Renacer)","Bolívares","77688","2024-08-05","36.67","1.00","1","36.65");
INSERT INTO pagos VALUES("288","144","Ganancia","Ganancia","Ganancia","2024-08-05","","54","1","");
INSERT INTO pagos VALUES("289","144","Divisas","Divisas","-","2024-08-01","-","12.00","1","-");
INSERT INTO pagos VALUES("290","144","Divisas","Divisas","-","2024-08-01","-","12,01","1","-");
INSERT INTO pagos VALUES("291","144","Divisas","Divisas","-","2024-08-01","-","12,01","1","-");
INSERT INTO pagos VALUES("292","144","Divisas","Divisas","-","2024-08-01","-","12,01","1","-");
INSERT INTO pagos VALUES("293","144","Divisas","Divisas","-","2024-08-01","-","12.01","1","-");
INSERT INTO pagos VALUES("294","145","Ganancia","Ganancia","Ganancia","2024-08-15","","44","1","");
INSERT INTO pagos VALUES("295","146","Ganancia","Ganancia","Ganancia","2024-08-15","","44","1","");
INSERT INTO pagos VALUES("296","147","Ganancia","Ganancia","Ganancia","2024-08-15","","44","1","");
INSERT INTO pagos VALUES("297","148","Ganancia","Ganancia","Ganancia","2024-08-15","","44","1","");
INSERT INTO pagos VALUES("298","149","Ganancia","Ganancia","Ganancia","2024-08-15","","44","1","");
INSERT INTO pagos VALUES("299","148","Divisas","Divisas","-","2024-08-16","-","1","1","-");
INSERT INTO pagos VALUES("300","149","Divisas","Divisas","-","2024-08-24","-","1","1","-");
INSERT INTO pagos VALUES("301","149","Divisas","Divisas","-","2024-08-24","-","1","1","-");
INSERT INTO pagos VALUES("302","149","Divisas","Divisas","-","2024-08-24","-","1","1","-");
INSERT INTO pagos VALUES("303","149","Divisas","Divisas","-","2024-08-24","-","1","1","-");
INSERT INTO pagos VALUES("304","140","Divisas","Divisas","-","2024-08-16","-","50","1","-");
INSERT INTO pagos VALUES("305","141","Divisas","Divisas","-","2024-08-31","-","1","1","-");
INSERT INTO pagos VALUES("306","140","Divisas","Divisas","-","2024-08-17","-","1","1","-");
INSERT INTO pagos VALUES("307","140","Divisas","Divisas","-","2024-08-31","-","75","1","-");
INSERT INTO pagos VALUES("308","150","Ganancia","Ganancia","Ganancia","2024-08-17","","54","1","");
INSERT INTO pagos VALUES("309","151","Ganancia","Ganancia","Ganancia","2024-08-17","","54","1","");



DROP TABLE IF EXISTS pagos_quincenales;

CREATE TABLE `pagos_quincenales` (
  `id` int NOT NULL AUTO_INCREMENT,
  `factura_id` int NOT NULL,
  `quincena` int NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `fecha_pago` date NOT NULL,
  `pagado` decimal(10,2) NOT NULL DEFAULT '0.00',
  `restante` decimal(10,2) NOT NULL,
  `estado` varchar(20) NOT NULL DEFAULT 'Pendiente',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO pagos_quincenales VALUES("171","135","1","86.00","2024-07-31","3.00","83.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("172","135","2","50.00","2024-08-15","0.00","50.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("173","136","1","80.00","2024-08-31","1.00","79.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("174","136","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("175","137","1","80.00","2024-08-31","1.00","79.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("176","137","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("177","138","1","80.00","2024-08-31","0.00","80.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("178","138","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("179","139","1","86.00","2024-07-31","0.00","86.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("180","139","2","50.00","2024-08-15","0.00","50.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("181","140","1","80.00","2024-08-31","80.00","0.00","Pagado");
INSERT INTO pagos_quincenales VALUES("182","140","2","46.00","2024-09-15","46.00","0.00","Pagado");
INSERT INTO pagos_quincenales VALUES("183","141","1","80.00","2024-08-31","1.00","79.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("184","141","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("185","142","1","80.00","2024-08-31","0.00","80.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("186","142","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("187","143","1","80.00","2024-08-31","0.00","80.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("188","143","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("189","144","1","80.00","2024-08-31","24.01","55.99","Pendiente");
INSERT INTO pagos_quincenales VALUES("190","144","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("191","145","1","86.00","2024-07-31","0.00","86.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("192","145","2","50.00","2024-08-15","0.00","50.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("193","146","1","86.00","2024-07-31","0.00","86.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("194","146","2","50.00","2024-08-15","0.00","50.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("195","147","1","86.00","2024-07-31","0.00","86.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("196","147","2","50.00","2024-08-15","0.00","50.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("197","148","1","86.00","2024-07-31","1.00","85.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("198","148","2","50.00","2024-08-15","0.00","50.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("199","149","1","86.00","2024-07-31","4.00","82.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("200","149","2","50.00","2024-08-15","0.00","50.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("201","150","1","80.00","2024-08-31","0.00","80.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("202","150","2","46.00","2024-09-15","0.00","46.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("203","151","1","80.00","2024-08-31","0.00","80.00","Pendiente");
INSERT INTO pagos_quincenales VALUES("204","151","2","46.00","2024-09-15","0.00","46.00","Pendiente");



DROP TABLE IF EXISTS permisos;

CREATE TABLE `permisos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(30) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

INSERT INTO permisos VALUES("1","configuración");
INSERT INTO permisos VALUES("2","usuarios");
INSERT INTO permisos VALUES("3","clientes");
INSERT INTO permisos VALUES("4","productos");
INSERT INTO permisos VALUES("5","ventas");
INSERT INTO permisos VALUES("6","nueva_venta");



DROP TABLE IF EXISTS premios;

CREATE TABLE `premios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tipo` enum('Basica','Especial') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO premios VALUES("2","Basica","Olla Tipo (A)");
INSERT INTO premios VALUES("3","Especial","Olla Tipo (B)");
INSERT INTO premios VALUES("4","Basica","Zapato A");
INSERT INTO premios VALUES("5","Especial","Zapato B");



DROP TABLE IF EXISTS premios_asignados;

CREATE TABLE `premios_asignados` (
  `id` int NOT NULL AUTO_INCREMENT,
  `factura_id` int NOT NULL,
  `premio_id` int NOT NULL,
  `tipo` enum('basico','especial') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `factura_id` (`factura_id`),
  KEY `premio_id` (`premio_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO premios_asignados VALUES("26","143","2","");
INSERT INTO premios_asignados VALUES("27","138","2","");
INSERT INTO premios_asignados VALUES("28","137","2","");
INSERT INTO premios_asignados VALUES("29","140","2","");
INSERT INTO premios_asignados VALUES("30","145","3","");



DROP TABLE IF EXISTS producto;

CREATE TABLE `producto` (
  `codproducto` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(255) NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `existencia` int NOT NULL,
  `usuario_id` int NOT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `ganancia` decimal(10,2) NOT NULL DEFAULT '0.00',
  `fecha_quincena1` date DEFAULT NULL,
  `fecha_quincena2` date DEFAULT NULL,
  `monto_quincena1` decimal(10,2) NOT NULL DEFAULT '0.00',
  `monto_quincena2` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tipo` enum('Basica','Especial') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`codproducto`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO producto VALUES("8","Coleccion Basica","180.00","7","1","1","54.00","2024-08-31","2024-09-15","80.00","46.00","Basica");
INSERT INTO producto VALUES("9","Coleccion Especial","180.00","18","1","1","44.00","2024-07-31","2024-08-15","86.00","50.00","Especial");



DROP TABLE IF EXISTS tasa_cambio;

CREATE TABLE `tasa_cambio` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fecha` date NOT NULL,
  `tasa` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_fecha` (`fecha`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO tasa_cambio VALUES("12","2024-08-05","36.65");



DROP TABLE IF EXISTS usuario;

CREATE TABLE `usuario` (
  `idusuario` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `correo` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `usuario` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `clave` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_spanish_ci NOT NULL,
  `estado` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`idusuario`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_spanish_ci ROW_FORMAT=DYNAMIC;

INSERT INTO usuario VALUES("1","Guillermo Ortiz","notify@metaflixstore.com","admin","21232f297a57a5a743894a0e4a801fc3","1");
INSERT INTO usuario VALUES("4","Carolina Molina","Carolina@metaflixstore.com","carolina","21232f297a57a5a743894a0e4a801fc3","1");
INSERT INTO usuario VALUES("5","Heidy Molina","heidymolina@gmail.com","heidy","21232f297a57a5a743894a0e4a801fc3","1");



DROP TABLE IF EXISTS usuarios;

CREATE TABLE `usuarios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(8) DEFAULT NULL,
  `password` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO usuarios VALUES("1","metaflix","6b86b273ff34fce19d6b804eff5a3f5747ada4eaa22f1d49c01e52ddb7875b4b");
INSERT INTO usuarios VALUES("2","1","6b86b273ff34fce19d6b804eff5a3f5747ada4eaa22f1d49c01e52ddb7875b4b");



DROP TABLE IF EXISTS vendedor;

CREATE TABLE `vendedor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cedula` varchar(20) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `sexo` char(1) NOT NULL,
  `fecha_nacimiento` date NOT NULL,
  `correo` varchar(100) NOT NULL,
  `direccion` text NOT NULL,
  `telefono` varchar(15) NOT NULL,
  `usuario_id` int NOT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO vendedor VALUES("1","17936444","Telema","Molina","M","2004-08-08","telema@dd.com","calabozo","584144560562","1","1");
INSERT INTO vendedor VALUES("2","30418662","Guillermo Alejandro","Ortiz Molina","M","2004-08-08","imguilleo@gmail.com","3001 W 16TH AVE","584127780807","1","1");
INSERT INTO vendedor VALUES("3","13948881","Guillermo Jesus","Ortiz Mendoza","M","2024-06-09","notify@metaflixstore.com","3001 W 16TH AVE","584127780807","1","1");
INSERT INTO vendedor VALUES("4","15812512","China","Molina","F","2024-07-19","guillermo@gmail.com","fedfsf","584127780807","1","1");
INSERT INTO vendedor VALUES("9","18220537","Heidy","Molina","F","2024-08-16","guillermo@gmail.com","casa 21","584124063307","5","1");



DROP TABLE IF EXISTS vendedores;

CREATE TABLE `vendedores` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




DROP TABLE IF EXISTS ventas;

CREATE TABLE `ventas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_cliente` int NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `id_usuario` int NOT NULL,
  `fecha` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

INSERT INTO ventas VALUES("1","1","42.00","1","2021-05-16 06:35:54");
INSERT INTO ventas VALUES("2","1","39.00","1","2021-05-16 06:39:39");
INSERT INTO ventas VALUES("3","4","0.00","1","2024-06-03 08:56:09");
INSERT INTO ventas VALUES("4","4","0.00","1","2024-06-03 08:56:56");
INSERT INTO ventas VALUES("5","4","0.00","1","2024-06-03 08:57:04");



